package ru.yandex.direct.logicprocessor.processors.moderation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.CampaignModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationRequest;

@Component
public class CampaignIdPartitionGroupComputer
        implements PartitionGroupComputer<ModerationRequest<? extends CampaignModerationMeta>> {

    @Override
    public <E extends ModerationRequest<? extends CampaignModerationMeta>>
    int computePartitionGroup(E moderationRequest, int totalGroups) {
        CampaignModerationMeta meta = moderationRequest.getMeta();
        return (int) (meta.getCampaignId() % totalGroups);
    }
}
