package ru.yandex.direct.logicprocessor.processors.moderation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.ess.logicobjects.image.ImageModerationEventsObject;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Service
public class ClientIdLoadingImageEventsService {

    private final BannerImageRepository bannerImageRepository;

    @Autowired
    public ClientIdLoadingImageEventsService(
            BannerImageRepository bannerImageRepository) {
        this.bannerImageRepository = bannerImageRepository;
    }

    public List<ModerationEventWithClientInfo<ImageModerationEventsObject>> mapEvents(int shard,
                                                                                      List<ImageModerationEventsObject> objects) {
        Set<Long> ids = listToSet(objects, ImageModerationEventsObject::getImageId);

        Map<Long, ClientId> clientIdsByImageIds =
                bannerImageRepository.getClientIdsByImageIds(shard, ids);

        return objects.stream()
                .filter(e -> clientIdsByImageIds.containsKey(e.getImageId()))
                .map(e ->
                        new ModerationEventWithClientInfo<>(e, clientIdsByImageIds.get(e.getImageId()).asLong()))
                .collect(Collectors.toList());
    }
}
