package ru.yandex.direct.logicprocessor.processors.moderation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.repository.BannerRelationsRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;
import ru.yandex.direct.ess.logicobjects.moderation.ModerationEventsObjectWithBannerId;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Service
public class ClientIdLoadingModerationEventsService {

    private final BannerRelationsRepository bannerRelationsRepository;

    @Autowired
    public ClientIdLoadingModerationEventsService(
            BannerRelationsRepository bannerRelationsRepository) {
        this.bannerRelationsRepository = bannerRelationsRepository;
    }

    public <T extends BaseModerationObject & ModerationEventsObjectWithBannerId> List<ModerationEventWithClientInfo<T>> mapEvents(int shard,
                                                                                                                                  List<T> objects) {
        Set<Long> bids = listToSet(objects, ModerationEventsObjectWithBannerId::getBannerId);

        Map<Long, ClientId> bannerTypeMap =
                bannerRelationsRepository.getClientIdsByBannerIds(shard, bids);

        return objects.stream()
                .filter(e -> bannerTypeMap.containsKey(e.getBannerId()))
                .map(e ->
                        new ModerationEventWithClientInfo<>(e, bannerTypeMap.get(e.getBannerId()).asLong()))
                .collect(Collectors.toList());
    }
}
