package ru.yandex.direct.logicprocessor.processors.moderation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.verdictrequest.contentpromotion.ContentPromotionModerationVerdictRequest;

@Component
public class ContentPromotionAccessibilityModerationRequestLogEntryCreator
        implements ModerationRequestLogEntryCreator<ContentPromotionModerationVerdictRequest> {

    @Override
    public <E extends ContentPromotionModerationVerdictRequest> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        BaseBannerModerationMeta meta = moderationRequest.getMeta();

        long campaignId = meta.getCampaignId();
        long adGroupId = meta.getAdGroupId();
        long bannerId = meta.getBannerId();

        return new ModerationLogEntry<>(campaignId, adGroupId, bannerId,
                ModerationLogEntry.Action.REQUEST, true, moderationRequest);
    }
}
