package ru.yandex.direct.logicprocessor.processors.moderation;

import java.util.Objects;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;

public class ModerationEventWithClientInfo<T extends BaseModerationObject> {
    private final T eventsObject;
    private final long clientId;

    public ModerationEventWithClientInfo(T eventsObject, long clientId) {
        this.eventsObject = eventsObject;
        this.clientId = clientId;
    }

    public T getEventsObject() {
        return eventsObject;
    }

    public long getClientId() {
        return clientId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ModerationEventWithClientInfo that = (ModerationEventWithClientInfo) o;
        return clientId == that.clientId &&
                Objects.equals(eventsObject, that.eventsObject);
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventsObject, clientId);
    }
}
