package ru.yandex.direct.logicprocessor.processors.moderation;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import ru.yandex.direct.ess.logicobjects.moderation.AbstractModerationEvent;

// Утилитные методы отправки в модерацию
public class ModerationRequestUtils {

    private ModerationRequestUtils() {
    }

    public static <E extends AbstractModerationEvent, U> Map<U, Long> getIdToEventTimeMap(
            List<E> events, Function<E, U> idExtractor) {
        Map<U, Optional<Long>> optionalMap = StreamEx.of(events)
                .mapToEntry(idExtractor, AbstractModerationEvent::getEventTime)
                .nonNullValues()
                .grouping(Collectors.maxBy(Comparator.naturalOrder()));
        return EntryStream.of(optionalMap)
                .filterValues(Optional::isPresent)
                .mapValues(Optional::get)
                .toMap();
    }

    public static <E extends AbstractModerationEvent, U> Map<U, String> getIdToEssTagMap(
            List<E> events, Function<E, U> idExtractor) {
        return StreamEx.of(events)
                .mapToEntry(idExtractor, AbstractModerationEvent::getEssTag)
                .distinctKeys()
                .nonNullValues()
                .toMap();
    }

}
