package ru.yandex.direct.logicprocessor.processors.moderation;

import java.util.List;
import java.util.function.Consumer;

import org.glassfish.jersey.internal.util.Producer;

import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;
import ru.yandex.monlib.metrics.labels.Labels;

public class ModerationRequestsConsumerBuilder {
    private final Producer<String> logicProcessorNameProducer;
    private final Producer<Integer> shardProducer;

        public ModerationRequestsConsumerBuilder(Producer<String> logicProcessorNameProducer,
                                                 Producer<Integer> shardProducer) {
        this.logicProcessorNameProducer = logicProcessorNameProducer;
        this.shardProducer = shardProducer;
    }

    public <R> Consumer<List<R>> build(ModerationRequestsWriter<R> writer,
                                                         ModerationWriterMonitoring moderationWriterMonitoring,
                                                         Labels labels) {
        return reqs -> {
            int sentRequestsCount = writer.writeRequests(reqs);
            moderationWriterMonitoring.incModerationRequestCount(sentRequestsCount, getLabelsForMonitoring(labels));
        };
    }

    public <R> Consumer<List<R>> build(
            ModerationRequestsWriter<R> writer,
            ModerationWriterMonitoring moderationWriterMonitoring) {
        return build(writer, moderationWriterMonitoring, Labels.empty());
    }

    public Labels getLabelsForMonitoring(Labels subLabels) {
        return Labels.of("moderation", logicProcessorNameProducer.call(), "shard",
                Integer.toString(shardProducer.call())).addAll(subLabels);
    }
}
