package ru.yandex.direct.logicprocessor.processors.moderation;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

import one.util.streamex.EntryStream;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@SuppressWarnings({"rawtypes", "unchecked"})
public class TestEnvModerationRequestFilter implements ModerationRequestFilter {

    private final Map<Class, Predicate> typeToPredicate;

    public TestEnvModerationRequestFilter(Map<Class, Predicate> typeToPredicate) {
        this.typeToPredicate = typeToPredicate;
    }

    public <T> List<T> filter(List<T> requests) {
        Predicate<T> compositePredicate = request -> {
            List<Predicate<T>> suitablePredicates = EntryStream.of(typeToPredicate)
                    .filterKeys(type -> type.isAssignableFrom(request.getClass()))
                    .values()
                    .map(p -> (Predicate<T>) p)
                    .toList();
            return suitablePredicates.isEmpty() ||
                    suitablePredicates.stream().anyMatch(predicate -> predicate.test(request));
        };
        return filterList(requests, compositePredicate);
    }
}
