package ru.yandex.direct.logicprocessor.processors.moderation.asset;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerButtonWithModerationInfo;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerButtonModerationRequest;
import ru.yandex.direct.core.entity.moderation.service.sending.BannerButtonSender;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.asset.BannerButtonModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.asset.BannerAssetModerationEventsObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BannerAssetSimpleModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.BannerButtonModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags =
        {DIRECT_PRIORITY_1})
@EssLogicProcessor(BannerButtonModerationConfig.class)
public class BannerButtonModerationEventsProcessor extends BannerAssetSimpleModerationEventsProcessor
        <BannerAssetModerationEventsObject, BannerButtonWithModerationInfo, BannerButtonModerationRequest> {

    @Autowired
    public BannerButtonModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerButtonSender bannerButtonSender,
            BannerButtonModerationWriter moderationWriter, ModerationWriterMonitoring moderationWriterMonitoring,
            ModerationOperationModeProvider moderationOperationModeProvider) {

        super(essLogicProcessorContext, bannerButtonSender, moderationWriter, moderationWriterMonitoring,
                moderationOperationModeProvider);
    }

}
