package ru.yandex.direct.logicprocessor.processors.moderation.asset;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerLogoWithModerationInfo;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerLogoModerationRequest;
import ru.yandex.direct.core.entity.moderation.service.sending.BannerLogoSender;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.asset.BannerLogoModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.asset.BannerAssetModerationEventsObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BannerAssetSimpleModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.BannerLogoModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags =
        {DIRECT_PRIORITY_1})
@EssLogicProcessor(BannerLogoModerationConfig.class)
public class BannerLogoModerationEventsProcessor extends BannerAssetSimpleModerationEventsProcessor
        <BannerAssetModerationEventsObject, BannerLogoWithModerationInfo, BannerLogoModerationRequest> {

    @Autowired
    public BannerLogoModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerLogoSender bannerLogoSender,
            BannerLogoModerationWriter moderationWriter,
            ModerationWriterMonitoring moderationWriterMonitoring,
            ModerationOperationModeProvider moderationOperationModeProvider) {

        super(essLogicProcessorContext, bannerLogoSender, moderationWriter, moderationWriterMonitoring,
                moderationOperationModeProvider);

    }

}
