package ru.yandex.direct.logicprocessor.processors.moderation.asset

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.core.entity.banner.model.BannerMulticardSetWithModerationInfo
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider
import ru.yandex.direct.core.entity.moderation.model.asset.BannerMulticardModerationRequest
import ru.yandex.direct.core.entity.moderation.service.sending.BannerMulticardSender
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.env.TestingOnly
import ru.yandex.direct.ess.config.moderation.asset.BannerMulticardModerationConfig
import ru.yandex.direct.ess.logicobjects.moderation.asset.BannerAssetModerationEventsObject
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.JugglerChecks
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext
import ru.yandex.direct.logicprocessor.processors.moderation.BannerAssetSimpleModerationEventsProcessor
import ru.yandex.direct.logicprocessor.processors.moderation.writers.BannerMulticardModerationWriter
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring


@JugglerChecks(
    JugglerCheck(
        ttl = JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly::class,
        tags = [CheckTag.DIRECT_PRIORITY_1_NOT_READY, CheckTag.DIRECT_MODERATION],
        notifications = [
            OnChangeNotification(
                recipient = [NotificationRecipient.LOGIN_DARKKEKS],
                method = [NotificationMethod.TELEGRAM],
                status = [JugglerStatus.CRIT, JugglerStatus.OK],
            )
        ]
    ),
    JugglerCheck(
        ttl = JugglerCheck.Duration(minutes = 10),
        needCheck = TestingOnly::class,
        tags = [CheckTag.DIRECT_PRIORITY_1_NOT_READY, CheckTag.DIRECT_MODERATION],
    ),
)
@EssLogicProcessor(BannerMulticardModerationConfig::class)
class BannerMulticardModerationEventsProcessor(
    essLogicProcessorContext: EssLogicProcessorContext,
    bannerMulticardSender: BannerMulticardSender,
    bannerMulticardModerationWriter: BannerMulticardModerationWriter,
    moderationWriterMonitoring: ModerationWriterMonitoring,
    moderationOperationModeProvider: ModerationOperationModeProvider,
) : BannerAssetSimpleModerationEventsProcessor<BannerAssetModerationEventsObject,
    BannerMulticardSetWithModerationInfo, BannerMulticardModerationRequest>(
    essLogicProcessorContext,
    bannerMulticardSender,
    bannerMulticardModerationWriter,
    moderationWriterMonitoring,
    moderationOperationModeProvider,
)
