package ru.yandex.direct.logicprocessor.processors.moderation.asset;

import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.direct.core.entity.banner.model.BannerVcardWithModerationInfo;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerVcardModerationRequest;
import ru.yandex.direct.core.entity.moderation.service.sending.BannerVcardSender;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.asset.BannerVcardModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.asset.BannerAssetModerationEventsObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BannerAssetSimpleModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.ClientIdLoadingModerationEventsService;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationEventWithClientInfo;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.BannerVcardModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_0, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags =
        {DIRECT_PRIORITY_0})
@EssLogicProcessor(BannerVcardModerationConfig.class)
public class BannerVcardModerationEventsProcessor extends BannerAssetSimpleModerationEventsProcessor
        <BannerAssetModerationEventsObject, BannerVcardWithModerationInfo, BannerVcardModerationRequest> {

    private final ClientIdLoadingModerationEventsService clientIdLoadingModerationEventsService;
    private final PpcProperty<Integer> newTransportEnabled;


    public BannerVcardModerationEventsProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                                BannerVcardSender bannerVcardSender,
                                                PpcPropertiesSupport ppcPropertiesSupport,
                                                ClientIdLoadingModerationEventsService clientIdLoadingModerationEventsService,
                                                BannerVcardModerationWriter moderationWriter,
                                                ModerationWriterMonitoring moderationWriterMonitoring,
                                                ModerationOperationModeProvider moderationOperationModeProvider) {
        super(essLogicProcessorContext, bannerVcardSender, moderationWriter, moderationWriterMonitoring,
                moderationOperationModeProvider);

        this.clientIdLoadingModerationEventsService = clientIdLoadingModerationEventsService;
        this.newTransportEnabled = ppcPropertiesSupport.get(PpcPropertyNames.ENABLE_VCARD_TRANSPORT_NEW_MODERATION,
                Duration.ofMinutes(1));
    }

    @Override
    protected List<Long> getObjectIds(List<BannerAssetModerationEventsObject> events) {
        return clientIdLoadingModerationEventsService.mapEvents(getShard(), events)
                .stream()
                .filter(this::isNewTransportEnabledForEvent)
                .map(e -> e.getEventsObject().getBannerId())
                .collect(Collectors.toList());
    }

    private boolean isNewTransportEnabledForEvent(ModerationEventWithClientInfo event) {
        return event.getClientId() % 100 < newTransportEnabled.getOrDefault(0);
    }
}
