package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.ad_image.AdImageBannerModerationRequest;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.AdImageBannerModerationConfig;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.AdImageBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_0, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_0})
@EssLogicProcessor(AdImageBannerModerationConfig.class)
public class AdImageBannerEventsProcessor extends BaseBannerModerationEventsProcessor<AdImageBannerModerationRequest> {
    private final AdImageBannerModerationEventsHandlerProvider adImageBannerModerationEventsHandlerProvider;
    private final BannerModerationEventsHandler bannerModerationEventsHandler;

    @Autowired
    public AdImageBannerEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerModerationEventsService bannerModerationService,
            AdImageBannerModerationEventsHandlerProvider adImageBannerModerationEventsHandlerProvider) {
        super(essLogicProcessorContext, bannerModerationService);

        this.adImageBannerModerationEventsHandlerProvider = adImageBannerModerationEventsHandlerProvider;
        this.bannerModerationEventsHandler = adImageBannerModerationEventsHandlerProvider.build(
                createModerationRequestsConsumerBuilder());
    }

    @Override
    protected List<? extends ModerationRequestsWriter> getWriters() {
        return adImageBannerModerationEventsHandlerProvider.getWriters();
    }

    @Override
    protected void processEventsWithInfo(List<BannerModerationEventsWithInfo> events) {
        bannerModerationEventsHandler.handleObjects(getShard(), events);
    }
}
