package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.creative.repository.CreativeInfo;
import ru.yandex.direct.core.entity.creative.repository.CreativeRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.ess.logicobjects.moderation.banner.BannerModerationEventsObject;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Service
public class BannerModerationEventsService {

    private final AdGroupRepository adGroupRepository;
    private final CampaignRepository campaignRepository;
    private final CreativeRepository creativeRepository;
    private final BannerImageRepository bannerImageRepository;
    private final DslContextProvider dslContextProvider;


    @Autowired
    public BannerModerationEventsService(AdGroupRepository adGroupRepository,
                                         CampaignRepository campaignRepository,
                                         CreativeRepository creativeRepository,
                                         BannerImageRepository bannerImageRepository,
                                         DslContextProvider dslContextProvider) {
        this.adGroupRepository = adGroupRepository;
        this.campaignRepository = campaignRepository;
        this.creativeRepository = creativeRepository;
        this.bannerImageRepository = bannerImageRepository;
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Заполняем пришедшие запросы от роутера дополнительными данными: тип группы и тип кампании баннера,
     * информация о картинках и креативах.
     */
    public List<BannerModerationEventsWithInfo> mapEventsToBannerWithInfo(int shard,
                                                                          List<BannerModerationEventsObject> objects) {
        Set<Long> groupIds = listToSet(objects, BannerModerationEventsObject::getAdGroupId);
        Set<Long> campaignIds = listToSet(objects, BannerModerationEventsObject::getCampaignId);
        Set<Long> bannerIds = listToSet(objects, BannerModerationEventsObject::getBannerId);

        Map<Long, AdGroupType> adGroupIdToType = adGroupRepository.getAdGroupTypesByIds(shard, groupIds);
        Map<Long, CampaignType> campaignIdToType = campaignRepository.getCampaignsTypeMap(shard, campaignIds);
        Map<Long, CreativeInfo> creativeTypeMap = creativeRepository.getCreativeInfoByBannerId(shard, bannerIds);
        Map<Long, List<Long>> imageIdsByBannerIds =
                bannerImageRepository.getImageIdsByBannerIds(dslContextProvider.ppc(shard), bannerIds);

        return StreamEx.of(objects)
                .map(object -> new BannerModerationEventsWithInfo(object.getEssTag(), object.getEventTime(), object.getWasCopied())
                        .withCampaignType(campaignIdToType.get(object.getCampaignId()))
                        .withAdGroupType(adGroupIdToType.get(object.getAdGroupId()))
                        .withCreativeInfo(creativeTypeMap.get(object.getBannerId()))
                        .withHasImage(imageIdsByBannerIds.containsKey(object.getBannerId()))
                        .withObject(object))
                .toList();
    }
}
