package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationRequest;
import ru.yandex.direct.ess.logicobjects.moderation.banner.BannerModerationEventsObject;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BaseModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;
import ru.yandex.direct.tracing.Trace;
import ru.yandex.direct.tracing.TraceProfile;

/**
 * Базовый класс для обработки баннеров принимает общий запрос {@link BannerModerationRequest}
 * т.к. наследники могут отправлять разные типы запросов для одного типа баннера в зависимости от типа группы/кампании.
 * см {@link BannerModerationEventsHandler}
 * <p>
 * Для приходящих BannerModerationEventsObject резолвит adGroupId, campaignId etc. и отправляет на обработку
 * сабклассам в processEventsWithInfo()
 */
public abstract class BaseBannerModerationEventsProcessor<T extends BannerModerationRequest> extends BaseModerationEventsProcessor<
        BannerModerationEventsObject> {
    public static final String BANNER_MODERATION_LOGBROKER_PREFIX = "banner-moderation";

    private final BannerModerationEventsService bannerModerationService;

    public BaseBannerModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerModerationEventsService bannerModerationService) {
        super(essLogicProcessorContext);

        this.bannerModerationService = bannerModerationService;
    }

    protected abstract void processEventsWithInfo(List<BannerModerationEventsWithInfo> events);

    @Override
    protected void processObjects(List<BannerModerationEventsObject> events) {
        List<BannerModerationEventsWithInfo> eventsWithInfo = bannerModerationService
                .mapEventsToBannerWithInfo(getShard(), events);
        try (TraceProfile profile = Trace.current().profile(
                "banner_moderation_requests.make", String.valueOf(getShard()))) {
            processEventsWithInfo(eventsWithInfo);
        }
    }

}
