package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.contentpromotion.ContentPromotionBannerModerationRequest;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.ContentPromotionBannerModerationConfig;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.ContentPromotionBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;

/**
 * Для баннера content_promotion создает запрос на модерацию в формате {@link ContentPromotionBannerModerationRequest}
 */
@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_1})
@EssLogicProcessor(ContentPromotionBannerModerationConfig.class)
public class ContentPromotionBannerModerationEventsProcessor extends BaseBannerModerationEventsProcessor<ContentPromotionBannerModerationRequest> {
    private final ContentPromotionBannerModerationEventsHandlerProvider contentPromotionBannerModerationEventsHandlerProvider;
    private final BannerModerationEventsHandler bannerModerationEventsHandler;

    @Autowired
    public ContentPromotionBannerModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerModerationEventsService bannerModerationService,
            ContentPromotionBannerModerationEventsHandlerProvider contentPromotionBannerModerationEventsHandlerProvider) {
        super(essLogicProcessorContext, bannerModerationService);

        this.contentPromotionBannerModerationEventsHandlerProvider = contentPromotionBannerModerationEventsHandlerProvider;
        this.bannerModerationEventsHandler = contentPromotionBannerModerationEventsHandlerProvider.build(
                createModerationRequestsConsumerBuilder());

    }

    @Override
    protected void processEventsWithInfo(List<BannerModerationEventsWithInfo> events) {
        bannerModerationEventsHandler.handleObjects(getShard(), events);
    }

    @Override
    protected List<? extends ModerationRequestsWriter> getWriters() {
        return contentPromotionBannerModerationEventsHandlerProvider.getWriters();
    }

}
