package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.cpm.audio.CpmAudioBannerModerationRequest;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.CpmAudioBannerModerationConfig;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.CpmAudioBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.CpmBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.CpmGeoPinBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;


/**
 * Для баннера cpm_audio создает запрос на модерацию в формате
 * {@link CpmAudioBannerModerationRequest}
 */
@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_0, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags =
        {DIRECT_PRIORITY_0})
@EssLogicProcessor(CpmAudioBannerModerationConfig.class)
public class CpmAudioBannerModerationEventsProcessor extends BaseBannerModerationEventsProcessor<CpmAudioBannerModerationRequest> {
    private final CpmAudioBannerModerationEventsHandlerProvider cpmAudioBannerModerationEventsHandlerProvider;
    private final BannerModerationEventsHandler bannerModerationEventsHandler;

    @Autowired
    public CpmAudioBannerModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerModerationEventsService bannerModerationService,
            CpmAudioBannerModerationEventsHandlerProvider cpmAudioBannerModerationEventsHandlerProvider,
            CpmBannerModerationEventsHandlerProvider cpmBannerModerationEventsHandlerProvider,
            CpmGeoPinBannerModerationEventsHandlerProvider cpmGeoPinBannerModerationEventsHandlerProvider) {
        super(essLogicProcessorContext, bannerModerationService);

        this.cpmAudioBannerModerationEventsHandlerProvider = cpmAudioBannerModerationEventsHandlerProvider;
        this.bannerModerationEventsHandler = cpmAudioBannerModerationEventsHandlerProvider.build(
                createModerationRequestsConsumerBuilder());
    }

    @Override
    protected void processEventsWithInfo(List<BannerModerationEventsWithInfo> events) {
        bannerModerationEventsHandler.handleObjects(getShard(), events);
    }

    @Override
    protected List<? extends ModerationRequestsWriter> getWriters() {
        return cpmAudioBannerModerationEventsHandlerProvider.getWriters();
    }

}
