package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationRequest;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.CpmBannerModerationConfig;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.CpmBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_1})
@EssLogicProcessor(CpmBannerModerationConfig.class)
public class CpmBannerModerationEventsProcessor extends BaseBannerModerationEventsProcessor<BannerModerationRequest> {
    private final CpmBannerModerationEventsHandlerProvider cpmBannerModerationEventsHandlerProvider;
    private final BannerModerationEventsHandler bannerModerationEventsHandler;

    @Autowired
    public CpmBannerModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerModerationEventsService bannerModerationService,
            CpmBannerModerationEventsHandlerProvider cpmBannerModerationEventsHandlerProvider) {

        super(essLogicProcessorContext, bannerModerationService);

        this.cpmBannerModerationEventsHandlerProvider = cpmBannerModerationEventsHandlerProvider;
        this.bannerModerationEventsHandler = cpmBannerModerationEventsHandlerProvider.build(
                createModerationRequestsConsumerBuilder());
    }

    @Override
    protected List<? extends ModerationRequestsWriter> getWriters() {
        return cpmBannerModerationEventsHandlerProvider.getWriters();
    }

    @Override
    protected void processEventsWithInfo(List<BannerModerationEventsWithInfo> events) {
        bannerModerationEventsHandler.handleObjects(getShard(), events);
    }
}
