package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.cpm.geopin.CpmGeoPinBannerModerationRequest;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.CpmGeoPinBannerModerationConfig;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.CpmGeoPinBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;

/**
 * Для баннера cpm_geo_pin создает запрос на модерацию в формате {@link CpmGeoPinBannerModerationRequest}
 */
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 5), needCheck = ProductionOnly.class,
        tags = {DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class)
@EssLogicProcessor(CpmGeoPinBannerModerationConfig.class)
public class CpmGeoPinBannerModerationEventsProcessor extends BaseBannerModerationEventsProcessor<CpmGeoPinBannerModerationRequest> {
    private final CpmGeoPinBannerModerationEventsHandlerProvider cpmGeoPinBannerModerationEventsHandlerProvider;
    private final BannerModerationEventsHandler bannerModerationEventsHandler;

    @Autowired
    public CpmGeoPinBannerModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerModerationEventsService bannerModerationService,
            CpmGeoPinBannerModerationEventsHandlerProvider cpmGeoPinBannerModerationEventsHandlerProvider) {
        super(essLogicProcessorContext, bannerModerationService);
        this.cpmGeoPinBannerModerationEventsHandlerProvider = cpmGeoPinBannerModerationEventsHandlerProvider;
        this.bannerModerationEventsHandler = cpmGeoPinBannerModerationEventsHandlerProvider.build(
                createModerationRequestsConsumerBuilder());
    }

    @Override
    protected void processEventsWithInfo(List<BannerModerationEventsWithInfo> events) {
        bannerModerationEventsHandler.handleObjects(getShard(), events);
    }

    @Override
    protected List<? extends ModerationRequestsWriter> getWriters() {
        return cpmGeoPinBannerModerationEventsHandlerProvider.getWriters();
    }

}
