package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.text.TextBannerModerationRequest;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.DynamicBannerModerationConfig;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.DynamicBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_0, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_0})
@EssLogicProcessor(DynamicBannerModerationConfig.class)
public class DynamicBannerEventsProcessor
        extends BaseBannerModerationEventsProcessor<TextBannerModerationRequest> {

    private final DynamicBannerModerationEventsHandlerProvider dynamicBannerModerationEventsHandlerProvider;
    private final BannerModerationEventsHandler bannerModerationEventsHandler;

    @Autowired
    public DynamicBannerEventsProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                        BannerModerationEventsService bannerModerationService,
                                        DynamicBannerModerationEventsHandlerProvider dynamicBannerModerationEventsHandlerProvider) {
        super(essLogicProcessorContext, bannerModerationService);

        this.dynamicBannerModerationEventsHandlerProvider = dynamicBannerModerationEventsHandlerProvider;
        this.bannerModerationEventsHandler = dynamicBannerModerationEventsHandlerProvider.build(
                createModerationRequestsConsumerBuilder());
    }

    @Override
    protected List<? extends ModerationRequestsWriter> getWriters() {
        return dynamicBannerModerationEventsHandlerProvider.getWriters();
    }

    @Override
    protected void processEventsWithInfo(List<BannerModerationEventsWithInfo> events) {
        bannerModerationEventsHandler.handleObjects(getShard(), events);
    }
}
