package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.internalad.InternalBannerModerationRequest;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.InternalBannerModerationConfig;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.InternalBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;

/**
 * Для баннера internal_banner создает запрос на модерацию в формате {@link InternalBannerModerationRequest}
 */
@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class)
@EssLogicProcessor(InternalBannerModerationConfig.class)
@ParametersAreNonnullByDefault
public class InternalBannerModerationEventsProcessor
        extends BaseBannerModerationEventsProcessor<InternalBannerModerationRequest> {

    private final BannerModerationEventsHandler bannerModerationEventsHandler;
    private final InternalBannerModerationEventsHandlerProvider internalBannerModerationEventsHandlerProvider;

    @Autowired
    public InternalBannerModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerModerationEventsService bannerModerationService,
            InternalBannerModerationEventsHandlerProvider internalBannerModerationEventsHandlerProvider) {
        super(essLogicProcessorContext, bannerModerationService);

        this.internalBannerModerationEventsHandlerProvider = internalBannerModerationEventsHandlerProvider;
        this.bannerModerationEventsHandler = internalBannerModerationEventsHandlerProvider.build(
                createModerationRequestsConsumerBuilder());
    }

    @Override
    protected void processEventsWithInfo(List<BannerModerationEventsWithInfo> events) {
        // todo это быстрый фикс, правильный будет здесь https://st.yandex-team.ru/DIRECT-155825
        // не забыть сделать filterAndSendBannersToModerate приватным
        bannerModerationEventsHandler.filterAndSendBannersToModerate(getShard(), events);
    }

    @Override
    protected List<? extends ModerationRequestsWriter> getWriters() {
        return internalBannerModerationEventsHandlerProvider.getWriters();
    }

}
