package ru.yandex.direct.logicprocessor.processors.moderation.banner;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.text.TextBannerModerationRequest;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.TextBannerModerationConfig;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.TextBannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_0, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_0})
@EssLogicProcessor(TextBannerModerationConfig.class)
public class TextBannerEventsProcessor extends BaseBannerModerationEventsProcessor<TextBannerModerationRequest> {
    private final TextBannerModerationEventsHandlerProvider textBannerModerationEventsHandlerProvider;
    private final BannerModerationEventsHandler bannerModerationEventsHandler;

    @Autowired
    public TextBannerEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            BannerModerationEventsService bannerModerationService,
            TextBannerModerationEventsHandlerProvider textBannerModerationEventsHandlerProvider) {
        super(essLogicProcessorContext, bannerModerationService);
        this.textBannerModerationEventsHandlerProvider = textBannerModerationEventsHandlerProvider;
        this.bannerModerationEventsHandler = textBannerModerationEventsHandlerProvider.build(
                createModerationRequestsConsumerBuilder());
    }

    @Override
    protected List<? extends ModerationRequestsWriter> getWriters() {
        return textBannerModerationEventsHandlerProvider.getWriters();
    }

    @Override
    protected void processEventsWithInfo(List<BannerModerationEventsWithInfo> events) {
        bannerModerationEventsHandler.handleObjects(getShard(), events);
    }
}
