package ru.yandex.direct.logicprocessor.processors.moderation.banner.support;

import java.util.Objects;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.creative.repository.CreativeInfo;
import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;
import ru.yandex.direct.ess.logicobjects.moderation.ModerationEventsObjectWithBannerId;
import ru.yandex.direct.ess.logicobjects.moderation.banner.BannerModerationEventsObject;

public class BannerModerationEventsWithInfo extends BaseModerationObject implements ModerationEventsObjectWithBannerId {

    private CampaignType campaignType;
    private AdGroupType adGroupType;
    private CreativeInfo creativeInfo;
    private BannerModerationEventsObject object;
    private boolean hasImage;

    public BannerModerationEventsWithInfo(String essTag, Long eventTime, Boolean wasCopied) {
        super(essTag, eventTime, wasCopied);
    }

    @Override
    public Long getObjectId() {
        return getBannerId();
    }

    public CreativeInfo getCreativeInfo() {
        return creativeInfo;
    }

    public boolean isHasImage() {
        return hasImage;
    }

    public BannerModerationEventsWithInfo withHasImage(boolean hasImage) {
        this.hasImage = hasImage;
        return this;
    }

    public BannerModerationEventsWithInfo withCreativeInfo(CreativeInfo creativeType) {
        this.creativeInfo = creativeType;
        return this;
    }

    public CampaignType getCampaignType() {
        return campaignType;
    }

    public BannerModerationEventsWithInfo withCampaignType(CampaignType campaignType) {
        this.campaignType = campaignType;
        return this;
    }

    public AdGroupType getAdGroupType() {
        return adGroupType;
    }

    public BannerModerationEventsWithInfo withAdGroupType(AdGroupType adGroupType) {
        this.adGroupType = adGroupType;
        return this;
    }

    public BannerModerationEventsObject getObject() {
        return object;
    }

    public BannerModerationEventsWithInfo withObject(BannerModerationEventsObject object) {
        this.object = object;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BannerModerationEventsWithInfo that = (BannerModerationEventsWithInfo) o;
        return hasImage == that.hasImage && campaignType == that.campaignType
                && adGroupType == that.adGroupType
                && Objects.equals(creativeInfo, that.creativeInfo)
                && Objects.equals(object, that.object);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), campaignType, adGroupType, creativeInfo, object, hasImage);
    }

    @Override
    public Long getBannerId() {
        return object.getBannerId();
    }
}
