package ru.yandex.direct.logicprocessor.processors.moderation.banner.support;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.service.sending.ContentPromotionBannerSender;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestsConsumerBuilder;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ContentPromotionModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ContentPromotionBannerModerationEventsHandlerProvider extends BannerModerationEventsHandlerProvider {
    private final ContentPromotionBannerSender contentPromotionBannerSender;
    private final ContentPromotionModerationWriter contentPromotionModerationWriter;
    private final ModerationWriterMonitoring moderationWriterMonitoring;
    private final ModerationOperationModeProvider moderationOperationModeProvider;
    @Autowired
    public ContentPromotionBannerModerationEventsHandlerProvider(ContentPromotionBannerSender contentPromotionBannerSender,
                                                                 ContentPromotionModerationWriter contentPromotionModerationWriter,
                                                                 ModerationWriterMonitoring moderationWriterMonitoring,
                                                                 ModerationOperationModeProvider moderationOperationModeProvider) {
        super(List.of(contentPromotionModerationWriter));

        this.contentPromotionBannerSender = contentPromotionBannerSender;
        this.contentPromotionModerationWriter = contentPromotionModerationWriter;
        this.moderationWriterMonitoring = moderationWriterMonitoring;
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public BannerModerationEventsHandler build(ModerationRequestsConsumerBuilder requestsConsumerBuilder) {
        return new BannerModerationEventsHandler.Builder()
                .addBannerModerationSupport(
                        BannerModerationSupport.forAllEvents(
                                BannersBannerType.content_promotion,
                                contentPromotionBannerSender,
                                requestsConsumerBuilder.build(contentPromotionModerationWriter, moderationWriterMonitoring)))
                .setModerationOperationModeProvider(moderationOperationModeProvider)
                .build();
    }
}
