package ru.yandex.direct.logicprocessor.processors.moderation.banner.support;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.service.sending.CpmAudioBannerSender;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestsConsumerBuilder;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.CpmAudioModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class CpmAudioBannerModerationEventsHandlerProvider extends BannerModerationEventsHandlerProvider {
    private final CpmAudioBannerSender cpmAudioBannerSender;
    private final CpmAudioModerationWriter cpmAudioModerationWriter;
    private final ModerationWriterMonitoring moderationWriterMonitoring;
    private final ModerationOperationModeProvider moderationOperationModeProvider;

    @Autowired
    public CpmAudioBannerModerationEventsHandlerProvider(CpmAudioBannerSender cpmAudioBannerSender,
                                                         CpmAudioModerationWriter cpmAudioModerationWriter,
                                                         ModerationWriterMonitoring moderationWriterMonitoring,
                                                         ModerationOperationModeProvider moderationOperationModeProvider) {
        super(List.of(cpmAudioModerationWriter));

        this.cpmAudioBannerSender = cpmAudioBannerSender;
        this.cpmAudioModerationWriter = cpmAudioModerationWriter;
        this.moderationWriterMonitoring = moderationWriterMonitoring;
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public BannerModerationEventsHandler build(ModerationRequestsConsumerBuilder requestsConsumerBuilder) {
        return new BannerModerationEventsHandler.Builder()
                .addBannerModerationSupport(
                        BannerModerationSupport.forAllEvents(BannersBannerType.cpm_audio,
                                cpmAudioBannerSender,
                                requestsConsumerBuilder.build(cpmAudioModerationWriter, moderationWriterMonitoring)))
                .setModerationOperationModeProvider(moderationOperationModeProvider)
                .build();
    }
}
