package ru.yandex.direct.logicprocessor.processors.moderation.banner.support;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.service.sending.CpmGeoPinBannerSender;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestsConsumerBuilder;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.GeoPinModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class CpmGeoPinBannerModerationEventsHandlerProvider extends BannerModerationEventsHandlerProvider {
    private final CpmGeoPinBannerSender cpmGeoPinBannerSender;
    private final GeoPinModerationWriter geoPinModerationWriter;
    private final ModerationWriterMonitoring moderationWriterMonitoring;
    private final ModerationOperationModeProvider moderationOperationModeProvider;

    @Autowired
    public CpmGeoPinBannerModerationEventsHandlerProvider(CpmGeoPinBannerSender cpmGeoPinBannerSender,
                                                   GeoPinModerationWriter geoPinModerationWriter,
                                                   ModerationWriterMonitoring moderationWriterMonitoring,
                                                   ModerationOperationModeProvider moderationOperationModeProvider) {
        super(List.of(geoPinModerationWriter));

        this.cpmGeoPinBannerSender = cpmGeoPinBannerSender;
        this.geoPinModerationWriter = geoPinModerationWriter;
        this.moderationWriterMonitoring = moderationWriterMonitoring;
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public BannerModerationEventsHandler build(ModerationRequestsConsumerBuilder requestsConsumerBuilder) {
        return new BannerModerationEventsHandler.Builder()
                .addBannerModerationSupport(
                        BannerModerationSupport.forAllEvents(
                                BannersBannerType.cpm_geo_pin,
                                cpmGeoPinBannerSender,
                                requestsConsumerBuilder.build(geoPinModerationWriter, moderationWriterMonitoring))
                )
                .setModerationOperationModeProvider(moderationOperationModeProvider)
                .build();
    }
}
