package ru.yandex.direct.logicprocessor.processors.moderation.banner.support;

import java.util.List;
import java.util.Objects;

import ru.yandex.direct.core.entity.creative.model.CreativeType;

public class CreativeSupport {
    private final CreativeType creativeType;
    private final Boolean isExpandedCreative;
    private final List<Long> layoutIds;
    private final List<Long> deniedLayoutIds;

    private CreativeSupport(CreativeType creativeType, boolean isExpandedCreative, List<Long> layoutIds,
                            List<Long> deniedLayoutIds) {
        this.creativeType = creativeType;
        this.isExpandedCreative = isExpandedCreative;
        this.layoutIds = layoutIds;
        this.deniedLayoutIds = deniedLayoutIds;
    }

    public List<Long> getDeniedLayoutIds() {
        return deniedLayoutIds;
    }

    public CreativeType getCreativeType() {
        return creativeType;
    }

    public Boolean isExpandedCreative() {
        return isExpandedCreative;
    }

    public List<Long> getLayoutIds() {
        return layoutIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreativeSupport that = (CreativeSupport) o;
        return creativeType == that.creativeType &&
                Objects.equals(isExpandedCreative, that.isExpandedCreative) &&
                Objects.equals(layoutIds, that.layoutIds) &&
                Objects.equals(deniedLayoutIds, that.deniedLayoutIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(creativeType, isExpandedCreative, layoutIds, deniedLayoutIds);
    }

    public static CreativeSupportBuilder builder() {
        return new CreativeSupportBuilder();
    }

    public static final class CreativeSupportBuilder {
        private CreativeType creativeType;
        private List<Long> layoutIds;
        private List<Long> deniedLayoutIds;
        private boolean isExtendedCreative;

        private CreativeSupportBuilder() {
        }

        public CreativeSupportBuilder withCreativeType(CreativeType creativeType) {
            this.creativeType = creativeType;
            return this;
        }

        public CreativeSupportBuilder withIsExtendedCreative(boolean isExtendedCreative) {
            this.isExtendedCreative = isExtendedCreative;
            return this;
        }

        public CreativeSupportBuilder withLayoutIdsIn(List<Long> layoutIds) {
            this.layoutIds = layoutIds;
            return this;
        }

        public CreativeSupport build() {
            return new CreativeSupport(creativeType, isExtendedCreative, layoutIds, deniedLayoutIds);
        }

        public CreativeSupportBuilder withLayoutIdsNotIn(List<Long> layoutIds) {
            this.deniedLayoutIds = layoutIds;
            return this;
        }
    }
}
