package ru.yandex.direct.logicprocessor.processors.moderation.banner.support;

import java.util.Collections;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.service.sending.InternalBannerSender;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestsConsumerBuilder;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.InternalBannerModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InternalBannerModerationEventsHandlerProvider extends BannerModerationEventsHandlerProvider {
    private final InternalBannerSender bannerSender;
    private final InternalBannerModerationWriter internalBannerModerationWriter;
    private final ModerationWriterMonitoring moderationWriterMonitoring;
    private final ModerationOperationModeProvider moderationOperationModeProvider;

    @Autowired
    public InternalBannerModerationEventsHandlerProvider(InternalBannerSender bannerSender,
                                                         InternalBannerModerationWriter internalBannerModerationWriter,
                                                         ModerationWriterMonitoring moderationWriterMonitoring,
                                                         ModerationOperationModeProvider moderationOperationModeProvider) {
        super(Collections.singletonList(internalBannerModerationWriter));

        this.bannerSender = bannerSender;
        this.internalBannerModerationWriter = internalBannerModerationWriter;
        this.moderationWriterMonitoring = moderationWriterMonitoring;
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public BannerModerationEventsHandler build(ModerationRequestsConsumerBuilder requestsConsumerBuilder) {
        return new BannerModerationEventsHandler.Builder()
                .addBannerModerationSupport(
                        BannerModerationSupport.forAllEvents(
                                BannersBannerType.internal,
                                bannerSender,
                                requestsConsumerBuilder.build(internalBannerModerationWriter, moderationWriterMonitoring)))
                .setModerationOperationModeProvider(moderationOperationModeProvider)
                .build();
    }
}
