package ru.yandex.direct.logicprocessor.processors.moderation.callout;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationRequest;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestLogEntryCreator;

@Component
public class CalloutModerationLogEntryCreator
        implements ModerationRequestLogEntryCreator<CalloutModerationRequest> {

    @Override
    public <E extends CalloutModerationRequest> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        return new ModerationLogEntry<>(0L, 0L, moderationRequest.getMeta().getCalloutId(),
                ModerationLogEntry.Action.REQUEST, true, moderationRequest);
    }
}
