package ru.yandex.direct.logicprocessor.processors.moderation.callout;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationRequest;
import ru.yandex.direct.logicprocessor.processors.moderation.PartitionGroupComputer;

@Component
public class CalloutPartitionGroupComputer implements PartitionGroupComputer<CalloutModerationRequest> {
    @Override
    public <E extends CalloutModerationRequest> int computePartitionGroup(E moderationRequest, int totalGroups) {
        return (int) (moderationRequest.getMeta().getCalloutId() % totalGroups);
    }
}
