package ru.yandex.direct.logicprocessor.processors.moderation.campaign;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.core.entity.moderation.model.campaign.CampaignModerationRequest;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestLogEntryCreator;

@Component
public class CampaignModerationLogEntryCreator implements ModerationRequestLogEntryCreator<CampaignModerationRequest> {
    @Override
    public <E extends CampaignModerationRequest> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        return new ModerationLogEntry<>(moderationRequest.getMeta().getCampaignId(), 0L, 0L,
                ModerationLogEntry.Action.REQUEST, true, moderationRequest);
    }
}
