package ru.yandex.direct.logicprocessor.processors.moderation.campaign;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.campaign.CampaignModerationRequest;
import ru.yandex.direct.logicprocessor.processors.moderation.PartitionGroupComputer;

@Component
public class CampaignPartitionGroupComputer
        implements PartitionGroupComputer<CampaignModerationRequest> {
    @Override
    public <E extends CampaignModerationRequest>  int computePartitionGroup(E moderationRequest, int totalGroups) {
        return (int) (moderationRequest.getMeta().getCampaignId() % totalGroups);
    }
}
