package ru.yandex.direct.logicprocessor.processors.moderation.campaign.copy;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.campaign.CampaignCopyModerationRequest;
import ru.yandex.direct.ess.logicobjects.moderation.campaign.CampaignModerationEvent;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Конвертирует сырое событие из роутера в представление для отправки в модерацию через LogBroker.
 */
@Component
public class CampaignCopyModerationEventConverter {
    public CampaignCopyModerationRequest convert(CampaignModerationEvent event) {

        checkNotNull(event.getToCampaignId(), "CampaignCopyModerationEvent.toCampaignId");
        checkNotNull(event.getToClientId(), "CampaignCopyModerationEvent.toClientId");
        checkNotNull(event.getToUid(), "CampaignCopyModerationEvent.totUid");
        checkNotNull(event.getFromCampaignId(), "CampaignCopyModerationEvent.fromCampaignId");

        CampaignCopyModerationRequest request = new CampaignCopyModerationRequest();
        request.setFromCampaignId(event.getFromCampaignId());
        request.setToCampaignId(event.getToCampaignId());
        request.setToClientId(event.getToClientId());
        request.setToUid(event.getToUid());

        return request;
    }
}
