package ru.yandex.direct.logicprocessor.processors.moderation.campaign.copy;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.core.entity.moderation.model.campaign.CampaignCopyModerationRequest;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestLogEntryCreator;

@Component
public class CampaignCopyModerationLogEntryCreator implements ModerationRequestLogEntryCreator<CampaignCopyModerationRequest> {

    @Override
    public <E extends CampaignCopyModerationRequest> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        return new ModerationLogEntry<>(moderationRequest.getToCampaignId(), 0L, 0L,
                ModerationLogEntry.Action.REQUEST, true, moderationRequest);
    }
}
