package ru.yandex.direct.logicprocessor.processors.moderation.contentpromotion;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.moderation.model.verdictrequest.contentpromotion.ContentPromotionAccessibilityData;
import ru.yandex.direct.core.entity.moderation.model.verdictrequest.contentpromotion.ContentPromotionModerationVerdictRequest;
import ru.yandex.direct.core.entity.moderation.service.ModerationService;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.contentpromotion.ContentPromotionAccessibilityConfig;
import ru.yandex.direct.ess.logicobjects.moderation.contentpromotion.ContentPromotionAccessibilityLogicObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BaseModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ContentPromotionAccessibilityModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_1})
@EssLogicProcessor(ContentPromotionAccessibilityConfig.class)
public final class ContentPromotionAccessibilityEventsProcessor
        extends BaseModerationEventsProcessor<
        ContentPromotionAccessibilityLogicObject> {

    private final ModerationService moderationService;
    private final ContentPromotionAccessibilityModerationWriter moderationWriter;
    private final ModerationWriterMonitoring moderationWriterMonitoring;


    public ContentPromotionAccessibilityEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            ModerationService moderationService,
            ContentPromotionAccessibilityModerationWriter moderationWriter,
            ModerationWriterMonitoring moderationWriterMonitoring) {
        super(essLogicProcessorContext);
        this.moderationService = moderationService;
        this.moderationWriter = moderationWriter;
        this.moderationWriterMonitoring = moderationWriterMonitoring;
    }

    @Override
    protected void processObjects(List<ContentPromotionAccessibilityLogicObject> events) {
        List<ContentPromotionAccessibilityData> contentPromotionInaccessibleData = mapList(events,
                ContentPromotionAccessibilityEventsProcessor::mapLogicObjectToData);

        moderationService
                .makeContentPromotionAccessibilityVerdictsRequests(getShard(), contentPromotionInaccessibleData,
                        makeRequestsConsumer(moderationWriter, moderationWriterMonitoring));
    }

    @Override
    protected List<ModerationRequestsWriter<? extends ContentPromotionModerationVerdictRequest>> getWriters() {
        return List.of(moderationWriter);
    }

    private static ContentPromotionAccessibilityData mapLogicObjectToData(
            ContentPromotionAccessibilityLogicObject logicObject) {
        return new ContentPromotionAccessibilityData(logicObject.getContentPromotionId(),
                logicObject.getIsInaccessible() != 0);
    }
}
