package ru.yandex.direct.logicprocessor.processors.moderation.displayhrefs;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.displayhrefs.model.DisplayHrefWithModerationInfo;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.displayhrefs.DisplayHrefsModerationRequest;
import ru.yandex.direct.core.entity.moderation.service.sending.DisplayHrefsSender;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.DisplayHrefsModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.displayhrefs.DisplayHrefsModerationEventsObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BannerAssetSimpleModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.DisplayhrefsModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags =
        {DIRECT_PRIORITY_1})
@EssLogicProcessor(DisplayHrefsModerationConfig.class)
public class DisplayHrefsModerationEventsProcessor extends BannerAssetSimpleModerationEventsProcessor
        <DisplayHrefsModerationEventsObject, DisplayHrefWithModerationInfo, DisplayHrefsModerationRequest> {

    @Autowired
    public DisplayHrefsModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            DisplayHrefsSender displayHrefsSender, DisplayhrefsModerationWriter moderationWriter,
            ModerationWriterMonitoring moderationWriterMonitoring,
            ModerationOperationModeProvider moderationOperationModeProvider) {

        super(essLogicProcessorContext, displayHrefsSender, moderationWriter, moderationWriterMonitoring,
                moderationOperationModeProvider);
    }

}
