package ru.yandex.direct.logicprocessor.processors.moderation.images;

import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.direct.core.entity.image.model.ImageWithModerationInfo;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.image.ImageModerationRequest;
import ru.yandex.direct.core.entity.moderation.service.sending.ImageSender;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.ImageModerationConfig;
import ru.yandex.direct.ess.logicobjects.image.ImageModerationEventsObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BannerAssetSimpleModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.ClientIdLoadingImageEventsService;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ImageModerationWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags =
        {DIRECT_PRIORITY_1})
@EssLogicProcessor(ImageModerationConfig.class)
public class ImageModerationEventsProcessor extends BannerAssetSimpleModerationEventsProcessor
        <ImageModerationEventsObject, ImageWithModerationInfo, ImageModerationRequest> {
    private final PpcProperty<Integer> imagesTransportEnabled;
    private final ClientIdLoadingImageEventsService clientIdLoadingModerationEventsService;

    @Autowired
    public ImageModerationEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            ImageSender imageSender, PpcPropertiesSupport ppcPropertiesSupport,
            ClientIdLoadingImageEventsService clientIdLoadingModerationEventsService,
            ImageModerationWriter moderationWriter, ModerationWriterMonitoring moderationWriterMonitoring,
            ModerationOperationModeProvider moderationOperationModeProvider) {

        super(essLogicProcessorContext, imageSender, moderationWriter, moderationWriterMonitoring,
                moderationOperationModeProvider, ImageWithModerationInfo::getId);

        this.imagesTransportEnabled =
                ppcPropertiesSupport.get(PpcPropertyNames.ENABLE_IMAGE_TRANSPORT_NEW_MODERATION,
                        Duration.ofMinutes(1));
        this.clientIdLoadingModerationEventsService = clientIdLoadingModerationEventsService;

    }

    @Override
    protected List<Long> getObjectIds(List<ImageModerationEventsObject> events) {
        return clientIdLoadingModerationEventsService.mapEvents(getShard(), events)
                .stream()
                .filter(e -> e.getClientId() % 100 < imagesTransportEnabled.getOrDefault(0))
                .map(e -> e.getEventsObject().getImageId()).collect(Collectors.toList());
    }
}
