package ru.yandex.direct.logicprocessor.processors.moderation.mobilecontenticon;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationRequest;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestLogEntryCreator;

@Component
public class MobileContentIconModerationLogEntryCreator
        implements ModerationRequestLogEntryCreator<MobileContentIconModerationRequest> {
    @Override
    public <E extends MobileContentIconModerationRequest> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        return new ModerationLogEntry<>(0L, 0L, moderationRequest.getMeta().getMobileContentId(),
                ModerationLogEntry.Action.REQUEST, true, moderationRequest);
    }
}
