package ru.yandex.direct.logicprocessor.processors.moderation.mobilecontenticon;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationRequest;
import ru.yandex.direct.logicprocessor.processors.moderation.PartitionGroupComputer;

@Component
public class MobileContentIconPartitionGroupComputer
        implements PartitionGroupComputer<MobileContentIconModerationRequest> {
    @Override
    public <E extends MobileContentIconModerationRequest> int computePartitionGroup(
            E moderationRequest, int totalGroups) {
        return (int) (moderationRequest.getMeta().getMobileContentId() % totalGroups);
    }
}
