package ru.yandex.direct.logicprocessor.processors.moderation.promoaction

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationRequest
import ru.yandex.direct.core.entity.moderation.service.sending.PromoExtensionSender
import ru.yandex.direct.core.entity.promoextension.model.PromoExtensionWithModerationInfo
import ru.yandex.direct.env.NonProductionEnvironment
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.ess.config.moderation.promoaction.PromoactionModerationConfig
import ru.yandex.direct.ess.logicobjects.moderation.promoaction.PromoactionModerationEventsObject
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext
import ru.yandex.direct.logicprocessor.processors.moderation.SimpleModerationEventsProcessor
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring
import ru.yandex.direct.logicprocessor.processors.moderation.writers.PromoactionModerationWriter
import ru.yandex.monlib.metrics.labels.Labels

@JugglerCheck(
    ttl = JugglerCheck.Duration(minutes = 5),
    needCheck = ProductionOnly::class,
    tags = [CheckTag.DIRECT_PRIORITY_1, CheckTag.DIRECT_MODERATION]
)
@JugglerCheck(
    ttl = JugglerCheck.Duration(minutes = 10),
    needCheck = NonProductionEnvironment::class,
    tags = [CheckTag.DIRECT_PRIORITY_1]
)
@EssLogicProcessor(PromoactionModerationConfig::class)
class PromoactionModerationEventsProcessor(
    essLogicProcessorContext: EssLogicProcessorContext,
    private val promoExtensionSender: PromoExtensionSender,
    private val promoactionModerationWriter: PromoactionModerationWriter,
    private val moderationWriterMonitoring: ModerationWriterMonitoring,
    private val moderationOperationModeProvider: ModerationOperationModeProvider,
) : SimpleModerationEventsProcessor<
    PromoactionModerationEventsObject, PromoExtensionWithModerationInfo, PromoExtensionModerationRequest>(
    essLogicProcessorContext,
    { it.promoExtensionId },
    promoExtensionSender,
    promoactionModerationWriter,
    moderationWriterMonitoring,
    moderationOperationModeProvider,
) {
    override fun getTypeSpecificLabelsForMonitoring() = Labels.of("type", "promo_extension")
}
