package ru.yandex.direct.logicprocessor.processors.moderation.promoaction

import org.springframework.stereotype.Component
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestLogEntryCreator
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationRequest
import ru.yandex.direct.common.log.container.ModerationLogEntry

@Component
class PromoactionModerationLogEntryCreator : ModerationRequestLogEntryCreator<PromoExtensionModerationRequest> {
    override fun <E : PromoExtensionModerationRequest> createLogEntry(moderationRequest: E): ModerationLogEntry<E> {
        return ModerationLogEntry(0L, 0L, moderationRequest.meta.promoExtensionId,
                ModerationLogEntry.Action.REQUEST, true, moderationRequest)
    }
}
