package ru.yandex.direct.logicprocessor.processors.moderation.sitelinks;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.sitelinks.SitelinksModerationRequest;
import ru.yandex.direct.core.entity.moderation.service.sending.SitelinksSender;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSetWithModerationInfo;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.banner.SitelinksModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.sitelinks.SitelinksModerationEventsObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BannerAssetSimpleModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.SitelinksModerationWriter;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags =
        {DIRECT_PRIORITY_1})
@EssLogicProcessor(SitelinksModerationConfig.class)
public class SitelinksModerationEventsProcessor extends BannerAssetSimpleModerationEventsProcessor
        <SitelinksModerationEventsObject, SitelinkSetWithModerationInfo, SitelinksModerationRequest> {

    @Autowired
    public SitelinksModerationEventsProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                              SitelinksSender sitelinksSender,
                                              SitelinksModerationWriter moderationWriter,
                                              ModerationWriterMonitoring moderationWriterMonitoring,
                                              ModerationOperationModeProvider moderationOperationModeProvider) {
        super(essLogicProcessorContext, sitelinksSender, moderationWriter, moderationWriterMonitoring,
                moderationOperationModeProvider);

    }

}
