package ru.yandex.direct.logicprocessor.processors.moderation.special.archiving;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestsConsumerBuilder;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandler;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsHandlerProvider;
import ru.yandex.direct.logicprocessor.processors.moderation.banner.support.BannerModerationEventsWithInfo;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class BannerInitialVersionEvaluator {

    private static final Logger logger = LoggerFactory.getLogger(BannerInitialVersionEvaluator.class);

    private List<BannerModerationEventsHandler> bannerModerationEventsHandlers;

    @Autowired
    public BannerInitialVersionEvaluator(List<BannerModerationEventsHandlerProvider> handlerProviders) {
        var dummyConsumerBuilder = new ModerationRequestsConsumerBuilder(() -> "", () -> null);
        this.bannerModerationEventsHandlers = mapList(handlerProviders, h -> h.build(dummyConsumerBuilder));
    }

    public Long getInitialVersion(BannerModerationEventsWithInfo event) {
        var suitableSupports = bannerModerationEventsHandlers.stream()
                .flatMap(h -> h.findSuitableSupportsForEvent(event).stream())
                .collect(Collectors.toList());

        if (suitableSupports.size() > 1) {
            logger.warn("Found more than one banner moderation support ({}) for event with bid {}",
                    suitableSupports.size(), event.getBannerId());
        }

        return suitableSupports.stream()
                .map(support -> support.getSender().initialVersion())
                .min(Comparator.naturalOrder())
                .orElse(null);
    }
}
