package ru.yandex.direct.logicprocessor.processors.moderation.special.archiving;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestLogEntryCreator;

@Component
public class ModerationArchivingLogEntryCreator
        implements ModerationRequestLogEntryCreator<ModerationArchivingRequest> {

    @Override
    public <E extends ModerationArchivingRequest> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        return new ModerationLogEntry<>(
                0,
                0,
                moderationRequest.getId(),
                ModerationLogEntry.Action.REQUEST,
                true,
                moderationRequest);
    }
}
