package ru.yandex.direct.logicprocessor.processors.moderation.special.archiving;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.circuits.moderation.ModerationArchivingObjectType;

public class ModerationArchivingRequest {

    @JsonProperty("type")
    private ModerationArchivingObjectType type;

    @JsonProperty("id")
    private Long id;

    @JsonProperty("version")
    private Long version;

    @JsonProperty("unixtime")
    private Long unixtime;

    public ModerationArchivingRequest(ModerationArchivingObjectType type, Long id, Long version, Long unixtime) {
        this.type = type;
        this.id = id;
        this.version = version;
        this.unixtime = unixtime;
    }

    public ModerationArchivingObjectType getType() {
        return type;
    }

    public Long getId() {
        return id;
    }

    public Long getVersion() {
        return version;
    }

    public Long getUnixtime() {
        return unixtime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ModerationArchivingRequest that = (ModerationArchivingRequest) o;
        return type == that.type && Objects.equals(id, that.id) && Objects.equals(version, that.version)
                && Objects.equals(unixtime, that.unixtime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, id, version, unixtime);
    }

    @Override
    public String toString() {
        return "ModerationArchivingRequest{" +
                "type=" + type +
                ", id=" + id +
                ", version=" + version +
                ", unixtime=" + unixtime +
                '}';
    }
}
