package ru.yandex.direct.logicprocessor.processors.moderation.special.archiving;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.ModerationLogService;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerProperties;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestFilter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriterImpl;

import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME;
import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_SPECIAL_ARCHIVING_REQUEST;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ModerationArchivingWriter extends ModerationRequestsWriterImpl<ModerationArchivingRequest> {

    @Autowired
    public ModerationArchivingWriter(
            EnvironmentType environmentType,
            ModerationRequestFilter filter,
            @Qualifier(MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME)
            LogbrokerClientFactoryFacade logbrokerClientFactory,
            ModerationArchivingLogEntryCreator moderationArchivingLogEntryCreator,
            ModerationLogService moderationLogService,
            @Qualifier(MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_SPECIAL_ARCHIVING_REQUEST)
            List<LogbrokerProducerProperties> producersProperties,
            ModerationArchivingPartitionGroupComputer moderationArchivingPartitionGroupComputer
    ) {
        super(environmentType,
                filter,
                logbrokerClientFactory,
                moderationArchivingLogEntryCreator,
                moderationLogService,
                producersProperties,
                moderationArchivingPartitionGroupComputer,
                "moderation",
                "archiving");
    }
}
