package ru.yandex.direct.logicprocessor.processors.moderation.special.deletion;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ess.logicobjects.moderation.special.ModerationDeletionEvent;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Конвертирует сырое событие из роутера в представление для отправки в модерацию через LogBroker.
 */
@Component
public class ModerationDeletionEventConverter {

    public ModerationDeletionRequest convert(ModerationDeletionEvent event) {
        checkNotNull(event.getId(), "ModerationDeletionEvent.id");
        checkNotNull(event.getType(), "ModerationDeletionEvent.type");
        checkNotNull(event.getEventTime(), "ModerationDeletionEvent.eventTime");

        ModerationDeletionRequest request = new ModerationDeletionRequest();
        request.setId(event.getId());
        request.setType(event.getType());
        request.setUnixtime(event.getEventTime());

        return request;
    }
}
