package ru.yandex.direct.logicprocessor.processors.moderation.special.deletion;

import java.util.List;
import java.util.function.Consumer;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.moderation.special.ModerationDeletionConfig;
import ru.yandex.direct.ess.logicobjects.moderation.special.ModerationDeletionEvent;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.BaseModerationEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;
import ru.yandex.direct.tracing.Trace;
import ru.yandex.direct.tracing.TraceProfile;
import ru.yandex.monlib.metrics.labels.Labels;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_MODERATION;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_1, DIRECT_MODERATION})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_1})
@EssLogicProcessor(ModerationDeletionConfig.class)
public class ModerationDeletionEventsProcessor extends BaseModerationEventsProcessor<ModerationDeletionEvent> {

    private final ModerationDeletionWriter moderationWriter;
    private final ModerationWriterMonitoring moderationWriterMonitoring;
    private final ModerationDeletionEventConverter moderationDeletionEventConverter;

    @Autowired
    public ModerationDeletionEventsProcessor(
            EssLogicProcessorContext essLogicProcessorContext,
            ModerationDeletionWriter moderationWriter,
            ModerationWriterMonitoring moderationWriterMonitoring,
            ModerationDeletionEventConverter moderationDeletionEventConverter) {

        super(essLogicProcessorContext);

        this.moderationWriter = moderationWriter;
        this.moderationWriterMonitoring = moderationWriterMonitoring;
        this.moderationDeletionEventConverter = moderationDeletionEventConverter;
    }

    @Override
    protected void processObjects(List<ModerationDeletionEvent> events) {
        try (TraceProfile profile = Trace.current().profile(
                "moderation_deleteion_requests.make", String.valueOf(getShard()))) {

            List<ModerationDeletionRequest> requests = mapList(events, moderationDeletionEventConverter::convert);
            requestsConsumer(moderationWriter, moderationWriterMonitoring).accept(requests);
        }
    }

    @Override
    protected List<ModerationRequestsWriter<? extends ModerationDeletionRequest>> getWriters() {
        return List.of(moderationWriter);
    }

    private <R> Consumer<List<R>> requestsConsumer(
            ModerationRequestsWriter<R> writer,
            ModerationWriterMonitoring moderationWriterMonitoring) {
        return reqs -> {
            int sentRequestsCount = writer.writeRequests(reqs);
            moderationWriterMonitoring.incModerationRequestCount(sentRequestsCount,
                    getLabelsForMonitoring(Labels.empty()));
        };
    }
}
