package ru.yandex.direct.logicprocessor.processors.moderation.special.deletion;

import java.util.Map;
import java.util.function.BiConsumer;

import com.google.common.collect.ImmutableMap;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.ess.common.circuits.moderation.ModerationDeletionObjectType;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestLogEntryCreator;

@Component
public class ModerationDeletionLogEntryCreator
        implements ModerationRequestLogEntryCreator<ModerationDeletionRequest> {

    private final Map<ModerationDeletionObjectType, BiConsumer<ModerationDeletionRequest, ObjectIds>> idsFillersMap;

    public ModerationDeletionLogEntryCreator() {
        idsFillersMap = buildFillersMap();
    }

    private Map<ModerationDeletionObjectType, BiConsumer<ModerationDeletionRequest, ObjectIds>> buildFillersMap() {
        BiConsumer<ModerationDeletionRequest, ObjectIds> bannerIdFiller =
                (req, objIds) -> objIds.bannerId = req.getId();
        BiConsumer<ModerationDeletionRequest, ObjectIds> adGroupIdFiller =
                (req, objIds) -> objIds.adGroupId = req.getId();

        ImmutableMap.Builder<ModerationDeletionObjectType, BiConsumer<ModerationDeletionRequest, ObjectIds>> builder =
                ImmutableMap.builder();

        builder.put(ModerationDeletionObjectType.BANNER, bannerIdFiller);
        builder.put(ModerationDeletionObjectType.ASSET_CREATIVE, bannerIdFiller);
        builder.put(ModerationDeletionObjectType.ASSET_IMAGE, bannerIdFiller);
        builder.put(ModerationDeletionObjectType.ASSET_DISPLAY_HREF, bannerIdFiller);
        builder.put(ModerationDeletionObjectType.ASSET_SITELINK_SET, bannerIdFiller);
        builder.put(ModerationDeletionObjectType.ASSET_TURBOLANDING, bannerIdFiller);
        builder.put(ModerationDeletionObjectType.ASSET_VCARD, bannerIdFiller);
        builder.put(ModerationDeletionObjectType.ASSET_BUTTON, bannerIdFiller);
        builder.put(ModerationDeletionObjectType.ASSET_LOGO, bannerIdFiller);
        builder.put(ModerationDeletionObjectType.ADGROUP, adGroupIdFiller);

        return builder.build();
    }

    @Override
    public <E extends ModerationDeletionRequest> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        ObjectIds objectIds = new ObjectIds();
        idsFillersMap.get(moderationRequest.getType()).accept(moderationRequest, objectIds);
        return new ModerationLogEntry<>(objectIds.campaignId, objectIds.adGroupId, objectIds.bannerId,
                ModerationLogEntry.Action.REQUEST, true, moderationRequest);
    }

    private static class ObjectIds {
        long campaignId;
        long adGroupId;
        long bannerId;
    }
}
