package ru.yandex.direct.logicprocessor.processors.moderation.special.deletion;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.ModerationLogService;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerProperties;
import ru.yandex.direct.logicprocessor.processors.moderation.ModerationRequestFilter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriterImpl;

import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME;
import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_SPECIAL_DELETION_REQUEST;

@Component
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ModerationDeletionWriter extends ModerationRequestsWriterImpl<ModerationDeletionRequest> {

    @Autowired
    public ModerationDeletionWriter(
            EnvironmentType environmentType,
            ModerationRequestFilter filter,
            @Qualifier(MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME)
                    LogbrokerClientFactoryFacade logbrokerClientFactory,
            ModerationDeletionLogEntryCreator moderationDeletionLogEntryCreator,
            ModerationLogService moderationLogService,
            @Qualifier(MODERATION_LOGBROKER_PRODUCERS_PROPERTIES_SPECIAL_DELETION_REQUEST)
                    List<LogbrokerProducerProperties> producersProperties,
            ModerationDeletionPartitionGroupComputer moderationDeletionPartitionGroupComputer
    ) {
        super(environmentType,
                filter,
                logbrokerClientFactory,
                moderationDeletionLogEntryCreator,
                moderationLogService,
                producersProperties,
                moderationDeletionPartitionGroupComputer,
                "moderation",
                "deletion");
    }
}
